/*
 * Decompiled with CFR 0.152.
 */
package chat;

import com.example.chat.ChatServiceGrpc;
import com.example.chat.ChatServiceOuterClass;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ChatClient {
    public static final String IP = "localhost";
    public static final int PORT = 1337;

    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("What's your nickname?");
        String nickname = br.readLine();
        System.out.println("---------");
        System.out.println("[CHAT CLIENT] Connecting to chat server @ localhost:1337");
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"localhost:1337").usePlaintext(true).build();
        System.out.println("[CHAT CLIENT] Connected!");
        System.out.println("[CHAT CLIENT] Establishing stream from server...");
        ChatServiceGrpc.ChatServiceStub stub = ChatServiceGrpc.newStub((Channel)channel);
        StreamObserver<ChatServiceOuterClass.ChatMessage> serverStream = stub.chat(new StreamObserver<ChatServiceOuterClass.ChatMessage>(){

            public void onNext(ChatServiceOuterClass.ChatMessage chatMessage) {
                String from = chatMessage.getFrom();
                String message = chatMessage.getMessage();
                System.out.println("\n" + from + " -> " + message);
            }

            public void onError(Throwable throwable) {
            }

            public void onCompleted() {
            }
        });
        System.out.println("[CHAT CLIENT] Now you can chat :)");
        while (true) {
            String message;
            if ((message = br.readLine()).equals("quit")) break;
            serverStream.onNext((Object)ChatServiceOuterClass.ChatMessage.newBuilder().setFrom(nickname).setMessage(message).build());
        }
        serverStream.onCompleted();
        System.out.println("Goodbye!");
    }
}

