/*
 * Decompiled with CFR 0.152.
 */
package grpchelloserver;

import com.example.grpc.GreetingServiceGrpc;
import com.example.grpc.GreetingServiceOuterClass;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;

public class GreetingServiceClient {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("Trying to call greeting synchronous method:\n");
        GreetingServiceClient.synchronousCall();
        System.out.println("\n...Done!");
        System.out.println("--------------");
        System.out.println("Now calling streamGreeting asynchronous method:\n");
        GreetingServiceClient.asynchronousStreamCall();
        System.out.println("\n...Done!");
    }

    public static void synchronousCall() {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"localhost:8080").usePlaintext(true).build();
        GreetingServiceGrpc.GreetingServiceBlockingStub stub = GreetingServiceGrpc.newBlockingStub((Channel)channel);
        GreetingServiceOuterClass.HelloRequest request = GreetingServiceOuterClass.HelloRequest.newBuilder().setName("Pippo").build();
        GreetingServiceOuterClass.HelloResponse response = stub.greeting(request);
        System.out.println(response.getGreeting());
        channel.shutdown();
    }

    public static void asynchronousStreamCall() throws InterruptedException {
        final ManagedChannel channel = ManagedChannelBuilder.forTarget((String)"localhost:8080").usePlaintext(true).build();
        GreetingServiceGrpc.GreetingServiceStub stub = GreetingServiceGrpc.newStub((Channel)channel);
        GreetingServiceOuterClass.HelloRequest request = GreetingServiceOuterClass.HelloRequest.newBuilder().setName("Pippo").build();
        stub.streamGreeting(request, new StreamObserver<GreetingServiceOuterClass.HelloResponse>(){

            public void onNext(GreetingServiceOuterClass.HelloResponse helloResponse) {
                System.out.println(helloResponse.getGreeting());
            }

            public void onError(Throwable throwable) {
                System.out.println("Error! " + throwable.getMessage());
            }

            public void onCompleted() {
                channel.shutdownNow();
            }
        });
        channel.awaitTermination(10L, TimeUnit.SECONDS);
    }
}

