var express = require('express');
var path = require('path');
var logger = require('morgan');
var bodyParser = require('body-parser');

var storage = require('./routes/storage')('mongodb://icarus:icarus@db/icarus');

var app = express();

app.use(logger('dev'));
app.use(bodyParser.json());

//enable CORS
app.use(function(req, res, next) {

  res.header("Access-Control-Allow-Origin", "*");
  res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Authorization");
  res.header("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");

  if(req.method=="OPTIONS"){

    res.sendStatus(204);

  }else{

    next();

  }

});

app.use('/icarus/str', storage);

// catch 404 and forward to error handler
app.use(function(req, res, next) {
  var err = new Error('Not Found');
  err.status = 404;
  next(err);
});

// error handlers

// development error handler
// will print stacktrace
if (app.get('env') === 'development') {
  app.use(function(err, req, res, next) {
    res.status(err.status || 500);
    res.send({
      message: err.message,
      error: err
    });
  });
}

// production error handler
// no stacktraces leaked to user
app.use(function(err, req, res, next) {
  res.status(err.status || 500);
  res.send({
    message: err.message,
    error: {}
  });
});

module.exports = app;
