package framework.everywaretechnologies.it.icarusandroid;

import android.content.SharedPreferences;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.Switch;

import framework.everywaretechnologies.it.icarus.EventTrackResource;
import framework.everywaretechnologies.it.icarus.Icarus;
import framework.everywaretechnologies.it.icarus.UserSettingsResource;


//classe di test Icarus framework

public class MainActivity extends AppCompatActivity {

    private final static String CLASS_NAME="MainActivity";

    private SharedPreferences myPrefs;
    private boolean lastBoolPref;
    private int lastIntPref;

    private Switch enteredExitedScreenTrackSwitch;
    private Switch boolPrefSwitch;
    private Switch intPrefSwitch;
    private Icarus instance;

    private String icarusUrl = "http://192.168.11.93:8082/icarus/str"; //PUT your own Icarus server URL

    private EditText eventNameEditText;
    Switch eventCategorySwitch;
    Switch eventLabelSwitch;
    private EditText mostProbableActivityEditText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //Set to Icarus instance an applicationContext and the SharedPreferences
        instance=Icarus.getInstance(MainActivity.this, icarusUrl);
        instance.setApplicationContext(getApplicationContext());

        enteredExitedScreenTrackSwitch=findViewById(R.id.entered_exited_screen_track_switch);
        boolPrefSwitch=findViewById(R.id.pref_bool_switch);
        intPrefSwitch=findViewById(R.id.pref_int_switch);

        //create two mock sharedPreferences to test pref Icarus' prefs change
        myPrefs=getSharedPreferences("MyPref",0);
        lastBoolPref=myPrefs.getBoolean("boolPref",false);
        lastIntPref=myPrefs.getInt("intPref",-1);

        instance.setCallerSharedPrefs(myPrefs);

        //set app switch based on sharedPreference values
        if(lastBoolPref) boolPrefSwitch.setChecked(true);
        else boolPrefSwitch.setChecked(false);

        if(lastIntPref==1)intPrefSwitch.setChecked(false);
        else intPrefSwitch.setChecked(true);

        eventNameEditText=findViewById(R.id.editText_eventName);
        eventCategorySwitch=findViewById(R.id.event_category_switch);
        eventLabelSwitch=findViewById(R.id.event_label_switch);
        mostProbableActivityEditText=findViewById(R.id.editText_mostProbableActivity);
    }

    //------------------------- UI EVENT -----------------------
    public void onBtnScreenEventTrack(View view){

        Log.d(CLASS_NAME,"on btn screen event track");

        String eventType=null;
        if(enteredExitedScreenTrackSwitch.isChecked())
            eventType=enteredExitedScreenTrackSwitch.getTextOn().toString();
        else
            eventType=enteredExitedScreenTrackSwitch.getTextOff().toString();

        instance.trackScreen(eventType,true);
    }

    public void onBtnUserPrefChanges(View view){

        Log.d(CLASS_NAME,"on btn log user changes");

        //take switch values
        boolean boolSwitchValue;
        int intSwitchValue;

        if(boolPrefSwitch.isChecked()) boolSwitchValue=Boolean.valueOf(boolPrefSwitch.getTextOn().toString());
        else boolSwitchValue=Boolean.valueOf(boolPrefSwitch.getTextOff().toString());

        if(intPrefSwitch.isChecked()) intSwitchValue=Integer.valueOf(intPrefSwitch.getTextOn().toString());
        else intSwitchValue=Integer.valueOf(intPrefSwitch.getTextOff().toString());

        UserSettingsResource userSettingsResource=new UserSettingsResource(myPrefs,MainActivity.this);

        userSettingsResource.addBoolean("boolPref",boolSwitchValue);
        userSettingsResource.addInt("intPref",intSwitchValue);

        instance.logUserSettings(userSettingsResource,true);
    }

    public void onBtnEventTrack(View view){

        Log.d(CLASS_NAME,"on btn track event");

        String eventName,mostProbableActivity;
        EventTrackResource.EventCategory eventCategory;
        EventTrackResource.EventLabel eventLabel;

        if(eventNameEditText.getText().length() == 0) eventName="eventoProva";
        else eventName=eventNameEditText.getText().toString();

        if(!eventCategorySwitch.isChecked()) eventCategory=EventTrackResource.EventCategory.APPLICATION;
        else eventCategory=EventTrackResource.EventCategory.ACTION;

        if(!eventLabelSwitch.isChecked()) eventLabel = EventTrackResource.EventLabel.FOREGROUND;
        else eventLabel=EventTrackResource.EventLabel.BACKGROUND;

        if(mostProbableActivityEditText.getText().length()==0) mostProbableActivity="running";
        else mostProbableActivity=mostProbableActivityEditText.getText().toString();

        EventTrackResource eventTrackResource=new EventTrackResource(eventName,eventCategory,eventLabel,90,90,5,
                mostProbableActivity,90,false);

        instance.logEvent(eventTrackResource,true);

    }
}
