package framework.everywaretechnologies.it.icarus;

import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import android.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class UserSettingsResource extends IcarusResource { //classe da non serializzare direttamente con Gson, ma pensata per essere compilata dall'app chiamante

    private final static String USER_SETTINGS_RES_CLASS="UserSettingsResource";

    //--------------- JSON KEYS -------------------------
    private final static String OLD_KEY="old";
    private final static String NEW_KEY="new";
    private final static String ACCESSIBILITY_COLOR_INVERSION_ENABLED_KEY="accessibility_color_inversion_enabled";
    private final static String FONT_SIZE_KEY="font_size";

    private Map<String,String> prefsOldNew; //il secondo String è in realtà un JSONObject convertito in String
    private SharedPreferences callerSharedPrefs;
    private Context c;

    public UserSettingsResource(SharedPreferences _callerSharedPrefs,Context _c){

        super();

        prefsOldNew=new HashMap<>();
        callerSharedPrefs=_callerSharedPrefs; //così posso modificare le SharedPreferences dell'app chiamante
        c=_c;
    }

    //a seconda del tipo di preferenza il chiamante invocherà uno di questi metodi

    public void addBoolean(String prefName, boolean newValue ) {

        JSONObject jsonObject=new JSONObject();
        try {

            if (callerSharedPrefs.contains(prefName + "_"+OLD_KEY)) { //se ho già toccato quella pref in passato

                boolean oldValue=callerSharedPrefs.getBoolean(prefName+"_"+OLD_KEY,false);

                if(oldValue!=newValue){

                    jsonObject.put(OLD_KEY, oldValue);
                    jsonObject.put(NEW_KEY,newValue);
                    prefsOldNew.put(prefName,jsonObject.toString());

                    //update shared preferences dell'app chiamante
                    SharedPreferences.Editor editor=callerSharedPrefs.edit();
                    editor.putBoolean(prefName+"_"+OLD_KEY,newValue);
                    editor.apply(); //apply aggiorna le prefs in bg
                }

            } else { //se è la prima volta che l'utente tocca quella pref

                jsonObject.put(OLD_KEY, null); //TODO: valutare se mettere null come "null" perchè se no nel JSON è come non mettere questo campo, non me lo mette proprio
                jsonObject.put(NEW_KEY,newValue);
                prefsOldNew.put(prefName,jsonObject.toString());

                //update shared preferences dell'app chiamante
                SharedPreferences.Editor editor=callerSharedPrefs.edit();
                editor.putBoolean(prefName+"_"+OLD_KEY,newValue);
                editor.apply(); //apply aggiorna le prefs in bg
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addInt(String prefName, int newValue ){

        JSONObject jsonObject=new JSONObject();
        try {

            if (callerSharedPrefs.contains(prefName + "_"+OLD_KEY)) {

                int oldValue=callerSharedPrefs.getInt(prefName+"_"+OLD_KEY,-1);

                if(oldValue!=newValue){

                    jsonObject.put(OLD_KEY, oldValue);
                    jsonObject.put(NEW_KEY,newValue);
                    prefsOldNew.put(prefName,jsonObject.toString());

                    //update shared preferences dell'app chiamante
                    SharedPreferences.Editor editor=callerSharedPrefs.edit();
                    editor.putInt(prefName+"_"+OLD_KEY,newValue);
                    editor.apply(); //apply aggiorna le prefs in bg
                }

            } else { //se è la prima volta che l'utente tocca quella pref

                jsonObject.put(OLD_KEY, null);
                jsonObject.put(NEW_KEY,newValue);
                prefsOldNew.put(prefName,jsonObject.toString());

                //update shared preferences dell'app chiamante
                SharedPreferences.Editor editor=callerSharedPrefs.edit();
                editor.putInt(prefName+"_"+OLD_KEY,newValue);
                editor.apply(); //apply aggiorna le prefs in bg
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addFloat(String prefName, float newValue ){

        JSONObject jsonObject=new JSONObject();
        try {

            if (callerSharedPrefs.contains(prefName + "_"+OLD_KEY)) {

                float oldValue=callerSharedPrefs.getFloat(prefName+"_"+OLD_KEY,-1);

                if(oldValue!=newValue){

                    jsonObject.put(OLD_KEY, oldValue);
                    jsonObject.put(NEW_KEY,newValue);
                    prefsOldNew.put(prefName,jsonObject.toString());

                    //update shared preferences dell'app chiamante
                    SharedPreferences.Editor editor=callerSharedPrefs.edit();
                    editor.putFloat(prefName+"_"+OLD_KEY,newValue);
                    editor.apply(); //apply aggiorna le prefs in bg
                }

            } else { //se è la prima volta che l'utente tocca quella pref

                jsonObject.put(OLD_KEY, null);
                jsonObject.put(NEW_KEY,newValue);
                prefsOldNew.put(prefName,jsonObject.toString());

                //update shared preferences dell'app chiamante
                SharedPreferences.Editor editor=callerSharedPrefs.edit();
                editor.putFloat(prefName+"_"+OLD_KEY,newValue);
                editor.apply(); //apply aggiorna le prefs in bg
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addLong(String prefName, long newValue ){

        JSONObject jsonObject=new JSONObject();
        try {

            if (callerSharedPrefs.contains(prefName + "_"+OLD_KEY)) {

                long oldValue=callerSharedPrefs.getLong(prefName+"_"+OLD_KEY,-1);

                if(oldValue!=newValue){

                    jsonObject.put(OLD_KEY, oldValue);
                    jsonObject.put(NEW_KEY,newValue);
                    prefsOldNew.put(prefName,jsonObject.toString());

                    //update shared preferences dell'app chiamante
                    SharedPreferences.Editor editor=callerSharedPrefs.edit();
                    editor.putFloat(prefName+"_"+OLD_KEY,newValue);
                    editor.apply(); //apply aggiorna le prefs in bg
                }

            } else { //se è la prima volta che l'utente tocca quella pref

                jsonObject.put(OLD_KEY, null);
                jsonObject.put(NEW_KEY,newValue);
                prefsOldNew.put(prefName,jsonObject.toString());

                //update shared preferences dell'app chiamante
                SharedPreferences.Editor editor=callerSharedPrefs.edit();
                editor.putFloat(prefName+"_"+OLD_KEY,newValue);
                editor.apply(); //apply aggiorna le prefs in bg
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addString(String prefName, String newValue ){

        JSONObject jsonObject=new JSONObject();
        try {

            if (callerSharedPrefs.contains(prefName + "_"+OLD_KEY)) {

                String oldValue=callerSharedPrefs.getString(prefName+"_"+OLD_KEY,"");

                if(!oldValue.equals(newValue)){

                    jsonObject.put(OLD_KEY, oldValue);
                    jsonObject.put(NEW_KEY,newValue);
                    prefsOldNew.put(prefName,jsonObject.toString());

                    //update shared preferences dell'app chiamante
                    SharedPreferences.Editor editor=callerSharedPrefs.edit();
                    editor.putString(prefName+"_"+OLD_KEY,newValue);
                    editor.apply(); //apply aggiorna le prefs in bg
                }

            } else { //se è la prima volta che l'utente tocca quella pref

                jsonObject.put(OLD_KEY, null);
                jsonObject.put(NEW_KEY,newValue);
                prefsOldNew.put(prefName,jsonObject.toString());

                //update shared preferences dell'app chiamante
                SharedPreferences.Editor editor=callerSharedPrefs.edit();
                editor.putString(prefName+"_"+OLD_KEY,newValue);
                editor.apply(); //apply aggiorna le prefs in bg
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getUserSettingsChangesInJSONFormat(){

        checkSystemPreferences();
        return new JSONObject(prefsOldNew);
    }

    public void clear(){ //reset di tutti i cambiamenti delle pref

        prefsOldNew.clear();
    }

    private void checkSystemPreferences(){

        int accessibilityDisplayColorInversionEnabled=-1;
        try{

            accessibilityDisplayColorInversionEnabled=Settings.Secure.getInt(c.getContentResolver(), Settings.Secure.ACCESSIBILITY_DISPLAY_INVERSION_ENABLED);
            int oldAccessibilityDisplayColorInversion=callerSharedPrefs.getInt(ACCESSIBILITY_COLOR_INVERSION_ENABLED_KEY,-1);

            if(oldAccessibilityDisplayColorInversion!=accessibilityDisplayColorInversionEnabled){

                JSONObject jsonObject=new JSONObject();
                jsonObject.put(OLD_KEY,oldAccessibilityDisplayColorInversion);
                jsonObject.put(NEW_KEY,accessibilityDisplayColorInversionEnabled);
                prefsOldNew.put(ACCESSIBILITY_COLOR_INVERSION_ENABLED_KEY,jsonObject.toString());

                SharedPreferences.Editor editor=callerSharedPrefs.edit();
                editor.putInt(ACCESSIBILITY_COLOR_INVERSION_ENABLED_KEY,accessibilityDisplayColorInversionEnabled);
                editor.apply();
            }

        } catch (Settings.SettingNotFoundException e){
            Log.i(USER_SETTINGS_RES_CLASS,"Setting Accessibility color inversion not found");

        } catch (JSONException e) {
            e.printStackTrace();
        }


        float fontSize=-1;
        try {

            fontSize=Settings.System.getFloat(c.getContentResolver(), Settings.System.FONT_SCALE);
            float oldFontSize=callerSharedPrefs.getFloat(FONT_SIZE_KEY,-1);

            if(oldFontSize!=fontSize){ //se dall'ultimo aggiornamento delle pref è cambiato

                JSONObject jsonObject=new JSONObject();
                jsonObject.put(OLD_KEY,oldFontSize);
                jsonObject.put(NEW_KEY,fontSize);
                prefsOldNew.put(FONT_SIZE_KEY,jsonObject.toString());

                SharedPreferences.Editor editor=callerSharedPrefs.edit();
                editor.putFloat(FONT_SIZE_KEY,fontSize);
                editor.apply();
            }
        } catch (Settings.SettingNotFoundException e){
            Log.i(USER_SETTINGS_RES_CLASS,"Setting Font size not found");

        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

}
