package framework.everywaretechnologies.it.icarus;

import org.json.JSONException;
import org.json.JSONObject;

public class EventTrackResource extends IcarusResource {

    //------------ JSON KEYS --------------------
    private final static String CONFIDENCE_KEY="confidence";
    private final static String START_TIMESTAMP_KEY="startTimestamp";
    private final static String HEADING_KEY="heading";
    private final static String COURSE_KEY="course";
    private final static String SPEED_KEY="speed";
    private final static String ACTIVITY_KEY="activity";
    private final static String DIRECTION_KEY="direction";
    private final static String EVENT_NAME_KEY="EventName";
    private final static String EVENT_CATEGORY_KEY="EventCategory";
    private final static String EVENT_LABEL_KEY="EventLabel";
    private final static String EVENT_CONTEXT_KEY="EventContext";

    //-----------------------------------------------------

    public enum EventCategory{ //categorie di evento

        APPLICATION,ACTION,NOTIFICATION;
    }

    public enum EventLabel{

        FOREGROUND,BACKGROUND;
    }

    private String eventName;
    private EventCategory eventCategory;
    private EventLabel eventLabel;

    private int heading;
    private int course;
    private int speed;

    //i due successivi attributi sono quelli ritornati dall'ActivityRecognition di Google che dev'essere implementata nell'app chiamante
    //convertiti da quelli di Google a quelli del server.. vedi iMoveAndroid per il metodo di mapping tra i valori ritornati da Google e quelli
    //per il server di ewtech. Fare copia incolla del metodo in progetti futuri. Non lo metto qua perchè da qua non ho accesso ai codici delle attività
    //non avendo la dipendenza all'ActivityRecognition all'interno di questa libreria
    private String mostProbableUserActivityName;
    private int confidence;

    private boolean accessibilityEnabled;

    private String[] userActivityToTrack;

    public EventTrackResource(String _eventName, EventCategory _eventCategory, EventLabel _eventLabel, int _heading, int _course, int _speed,
                              String _mostProbableUserActivityName, int _confidence, boolean _accessibilityEnabled){

        super();

        eventName=_eventName;
        eventCategory=_eventCategory;
        eventLabel=_eventLabel;
        heading=_heading;
        course=_course;
        speed=_speed;
        mostProbableUserActivityName=_mostProbableUserActivityName;
        confidence=_confidence;
        accessibilityEnabled=_accessibilityEnabled;

        userActivityToTrack=new String[]{"stationary","walking","running","automotive","cycling","unknown"};
    }

    public JSONObject getEventTrackResourceInJSONFormat(){

        JSONObject userActivityJSONObject=new JSONObject();

        try{

            for(String activityType: userActivityToTrack){

                if(activityType.equalsIgnoreCase(mostProbableUserActivityName))
                    userActivityJSONObject.put(activityType,true);
                else
                    userActivityJSONObject.put(activityType,false);

            }
            userActivityJSONObject.put(CONFIDENCE_KEY,confidence);
            userActivityJSONObject.put(START_TIMESTAMP_KEY,System.currentTimeMillis());

        } catch (JSONException jsonException){

            jsonException.printStackTrace();
        }

        JSONObject directionJSONObject=new JSONObject();

        try {

            directionJSONObject.put(HEADING_KEY,heading); //0..360
            directionJSONObject.put(COURSE_KEY,course); //0..360

        } catch (JSONException jsonException){

            jsonException.printStackTrace();
        }

        JSONObject eventContextJSONObject=new JSONObject();

        try {

            eventContextJSONObject.put(SPEED_KEY,speed);
            eventContextJSONObject.put(ACTIVITY_KEY,userActivityJSONObject);
            eventContextJSONObject.put(DIRECTION_KEY,directionJSONObject);

        } catch (JSONException jsonException){

            jsonException.printStackTrace();
        }

        JSONObject toSend=new JSONObject();

        try {

            toSend.put(EVENT_NAME_KEY,eventName);
            toSend.put(EVENT_CATEGORY_KEY,eventCategory.name().toLowerCase());
            toSend.put(EVENT_LABEL_KEY,eventLabel.name().toLowerCase()+"_TalkBack"+(accessibilityEnabled?"_ON":"_OFF"));
            toSend.put(EVENT_CONTEXT_KEY,eventContextJSONObject);

        } catch (JSONException jsonException){

            jsonException.printStackTrace();
        }

        return toSend;
    }


}
