package sums;

import java.io.*;
import java.net.*;

class Client {
    public static void main(String argv[]) throws Exception {
        String serverAddr;
        int portService;
        String numbers;
        float sum;

        // input stream initialization (from user keyboard)
        BufferedReader inFromUser =
                new BufferedReader(new InputStreamReader(System.in));

        System.out.print("Please, insert the server address: ");
        serverAddr = inFromUser.readLine();

        System.out.print("Please, insert the service port number: ");
        portService = Integer.parseInt(inFromUser.readLine());

        System.out.print("Please, insert two numbers separated by a blank space: ");
        numbers = inFromUser.readLine();

		/* client socket initialization
			localhost: server address
			6789: server service port number */
        Socket clientSocket = new Socket(serverAddr, portService);

        // output stream towards socket initialization
        DataOutputStream outToServer =
                new DataOutputStream(clientSocket.getOutputStream());

        // input stream from socket initialization
        BufferedReader inFromServer =
                new BufferedReader(
                        new InputStreamReader(clientSocket.getInputStream()));

        // send the line to the server
        outToServer.writeBytes(numbers + '\n');

        // read the response from the server
        sum = Float.parseFloat(inFromServer.readLine());
        System.out.println("SUM FROM SERVER: " + sum);
        clientSocket.close();
    }
}

