package sums;

import java.io.*;
import java.net.*;

public class ServerThread extends Thread {
    private Socket connectionSocket = null;
    private BufferedReader inFromClient;
    private DataOutputStream outToClient;

    // the constructor argument is an established socket
    public ServerThread(Socket s) {
        connectionSocket = s;
        try {
            inFromClient =
                    new BufferedReader(new InputStreamReader(connectionSocket.getInputStream()));
            outToClient = new DataOutputStream(connectionSocket.getOutputStream());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        String numbersString;
        String[] numbersArray;
        float sum;
        try {
            numbersString = inFromClient.readLine();
            numbersArray = numbersString.split(" ");
            sum = Float.parseFloat(numbersArray[0]) + Float.parseFloat(numbersArray[1]);
            outToClient.writeBytes(sum + "\n");
            connectionSocket.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}

