package chat;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public class Server {
    public static void main(String argv[]) throws Exception {
        Queue q = new Queue();

        // Thread that queues messages from the local user
        KeyboardThread kt = new KeyboardThread(q);
        kt.start();

        ServerSocket welcomeSocket = new ServerSocket(6789);
        Socket clientSocket = welcomeSocket.accept();

        // Thread that consumes local messages and sends them to the other user
        ToOtherUserThread ous = new ToOtherUserThread(clientSocket, q);
        ous.start();

        BufferedReader inFromClient =
                new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
        while(true) {
            System.out.println("FROM CLIENT: " + inFromClient.readLine());
        }
    }
}
