package chatRoom;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

public class MultiServer {
    public static void main(String argv[]) throws Exception {
        MultiQueue q = new MultiQueue();
        ArrayList<MultiServerThreadFromClient> tList = new ArrayList<MultiServerThreadFromClient>();

        // Thread that consumes from the queue containing messages from the different clients
        MultiServerThreadToClients mstc = new MultiServerThreadToClients(tList, q);
        mstc.start();

        ServerSocket welcomeSocket = new ServerSocket(6789);

        Socket clientSocket;
        MultiServerThreadFromClient msfc;
        int idCounter = 0;
        System.out.println("Ready to receive messages");
        while(true) {

            clientSocket = welcomeSocket.accept();

            idCounter++;

            // Thread that reads the message from a client and queues it to be forwarded to other clients
            msfc = new MultiServerThreadFromClient(clientSocket, q, idCounter);
            tList.add(msfc);
            msfc.start();
        }
    }
}
