package chatRoom;

import java.io.IOException;
import java.util.ArrayList;

public class MultiServerThreadToClients extends Thread {
    private ArrayList<MultiServerThreadFromClient> threads;
    private MultiQueue q;

    public MultiServerThreadToClients(ArrayList<MultiServerThreadFromClient> threads, MultiQueue q) {
        this.threads = threads;
        this.q = q;
    }

    public void run() {
        MultiMessage newMsg;
        while(true) {
            newMsg = q.take();

            for(MultiServerThreadFromClient t: threads) {
                try {
                    t.sendMsg(newMsg);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
