package students;

import com.google.gson.Gson;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;

public class Client {
    public static void main(String argv[]) throws Exception {
        Socket clientSocket = new Socket("localhost", 6789);

        DataOutputStream outToServer = new DataOutputStream(clientSocket.getOutputStream());

        ArrayList<Exam> passedExams = new ArrayList<Exam>();
        passedExams.add(new Exam("DPS", 30, new Date(31, 5, 2024)));

        Student student = new Student(
                "John",
                "Cena",
                1977,
                new Address("Via Celoria", 18),
                passedExams
        );

        Gson gson = new Gson();
        System.out.println("Bytes: " + gson.toJson(student).getBytes().length);
        outToServer.writeBytes(gson.toJson(student) + '\n');

        clientSocket.close();
    }
}
