package grpchelloserver;

import com.example.grpc.GreetingServiceGrpc.GreetingServiceImplBase;
import com.example.grpc.GreetingServiceOuterClass.*;
import io.grpc.stub.StreamObserver;

public class GreetingServiceImpl extends GreetingServiceImplBase {

    @Override
    public void greeting(HelloRequest request, StreamObserver<HelloResponse> responseObserver){

        //The request is a HelloRequest (defined in the .proto file)
        System.out.println(request);

        //Build the response of type HelloResponse (defined in the .proto file)
        HelloResponse response = HelloResponse.newBuilder().setGreeting("Hello there, "+request.getName()).build();

        //Pass the response to the stream
        responseObserver.onNext(response);

        //Finish the communication
        responseObserver.onCompleted();

    }

    @Override
    public void streamGreeting(HelloRequest request, StreamObserver<HelloResponse> responseObserver){

        System.out.println("Stream method called");

        //The request is a HelloRequest (defined in the .proto file)
        System.out.println(request);

        //Build the response of type HelloResponse (defined in the .proto file)
        HelloResponse response = HelloResponse.newBuilder().setGreeting("Hello there, "+request.getName()).build();

        //Pass the response to the stream
        responseObserver.onNext(response);
        responseObserver.onNext(response);
        responseObserver.onNext(response);

        //Finish the communication
        responseObserver.onCompleted();

    }

}
