# Setup REST and MQTT



* You can import the project directly from a *Version Control System*, by providing the following URL: 
https://ewserver.di.unimi.it/gitlab/michelefiori/Lab4-Examples

<img src = './assets/img_1.png'>


* Otherwise, take care to import the project as a Gradle Project
* If required, trust the project and accept the Gradle auto-import
* Wait until the Gradle indexing process ends (it may take a few seconds)

## REST

* Run Application.java located in: *REST\_MQTT_example/src/main/java/REST/*
    * Don't worry about the red *INFO* console prints
* Use a REST Client application (i.e., Advanced REST Client) to test if the server works correctly
* For example you can run the following request:

<img src = './assets/img_2.jpeg'>


## MQTT
* Mac OS:
  * Install homebrew from (https://brew.sh/index_it)
  * From the terminal:  
    `brew install mosquitto`  
    `brew services start mosquitto`  
    … running …  
    `brew services stop mosquitto`
* Windows:
  * Download and install the mosquitto broker from https://mosquitto.org/download/
  * Launch the mosquitto.exe file from C:\Program Files\Mosquitto
* Linux (http://www.steves-internet-guide.com/install-mosquitto-linux/):
  * From the terminal:  
    `sudo apt-add-repository ppa:mosquitto-dev/mosquitto-ppa`  
    `sudo apt-get update`  
    `sudo apt-get install mosquitto`  
    `sudo apt-get install mosquitto-clients`  
    `sudo apt clean`  
    `sudo service mosquitto start`  
    ... running …  
    `sudo service mosquitto stop`  


You can try to run the class SubExample and then the class PubExample to test that everything is working.
