In this project there are shown six micro applications that show how to implement accessibility functions both in a native way (with Android Studio in Java for Android and with Xcode in Swift for iOS) and in a cross-platform way (with Xamarin in C#).
The Accessibility functions that are shown in these micro apps are:
- AccessibilityName: show how to specify the attributes that contribute to form the text-to-announce. The methods used are "View.contentDescription
" in native Android, "UIAccessibility.accessibilityLabel"/"UIAccessibility.accessibilityHint" in native iOS and "AutomationProperties.SetName"/"AutomationProperties.SetHelpText" in Xamarin.Forms. In Xamarin it is also shown how to use Dependency Service to achieve that, due to the problem related to empty labels.
- AccessibilitySpeech: show how to read a text with the screen-reader TTS. The methods used are "View.announceForAccessibility" in native Android, "UIAccessibility.post(notification: .announcement, argument: stringToRead)" in native iOS and in Xamarin it uses the native C# methods througth Dependency Service.
- AccessibleView: show how to set a listener for accessibility events (e.g an interface object acquires or loses the focus). In native Android you have to override "onInitializeAccessibilityEvent", in native iOS to override "UIAccessibilityFocus.accessibilityElementDidBecomeFocused" and in Xamarin you have to override the native C# methods througth Custom Renderer. 
- ChangeFocus: show how to assign the accessibility focus to a user interface object. The methods used are "View.sendAccessibilityEvent(AccessibilityEvent.WINDOWS_CHANGE_ACCESSIBILITY_FOCUSED)" in native Android, "UIAccessibility.post(notification:.screenChanged, argument: destinationView)" in native iOS and in Xamarin it uses the native C# methods througth Dependency Service.
- DescribedByView: show how to make an user interface object to set the accessibility description of another user interface object. The methods used are "View.setLabelFor" in native Android, "UIAccessibility.accessibilityTitleUIElement" in native iOS (only available in Objective-C language) and "AutomationProperties.SetLabeledBy" in Xamarin.Forms.
- FocusOrder: show how to programmatically change the accessibility focus order. The methods used are "setAccessibilityTraversalAfter" in native Android, "UIAccessibilityContainer.UIView.accessibilityElements" in native iOS, and "TabIndex" in Xamarin.Forms
- HideFocus: show how to specify wheter a user interface object shouldn't receive the accessibility focus. The methods used are "View.importantForAccessibility" in native Android, "UIView.isAccessibilityElement" in native iOS and "AutomationProperties.SetIsInAccessibleTree" in Xamarin.Forms
